
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

from scipy.stats import gaussian_kde

# Sample data - crop yields in bushels per acre
wheat_data = np.random.normal(loc=60, scale=10, size=1000)  # Wheat yields
corn_data = np.random.normal(loc=150, scale=20, size=1000)  # Corn yields

# Compute density for each dataset
density_wheat = gaussian_kde(wheat_data)
density_corn = gaussian_kde(corn_data)
xs = np.linspace(30, 210, 300)
ys_wheat = density_wheat(xs)
ys_corn = density_corn(xs)

# Labels
labels = ["Wheat Yield", "Corn Yield"]
xlabel = "Density"
ylabel = "Yield (Bushels per Acre)"
title = "Crop Yield Density Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Fill between x for density regions
color_wheat = "#FFDD44"
color_corn = "#77CCFF"
plt.fill_betweenx(xs, ys_wheat, color=color_wheat, alpha=0.5, label=labels[0])
plt.fill_betweenx(xs, ys_corn, color=color_corn, alpha=0.5, label=labels[1])

# Set labels and title
ax.set_ylim(30, 210)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--")

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_35.pdf", bbox_inches="tight")
