
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
x = np.linspace(0, 100, 600)  # Simulate days
fields = ['Field A', 'Field B', 'Field C', 'Field D', 'Field E', 'Field F', 'Field G']
y = [
    np.random.uniform(20, 40) + np.sin(x - i) * np.random.uniform(5, 15)
    for index, i in enumerate(np.linspace(0, 100, len(fields)))
]

# Combine data for density estimation
data = np.concatenate(y)

# Kernel Density Estimation (KDE) for the soil moisture levels
kde = gaussian_kde(data, bw_method='scott')
x_dens = np.linspace(10, 50, 1000)
density = kde(x_dens)

# Extracted variables for the density plot
xlabel_text = "Day"
ylabel_text = "Soil Moisture Level"
title_text = "Density of Soil Moisture Levels Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 7))

# Plot the density curve for soil moisture levels
ax.plot(x_dens, density, color='purple', lw=2, label='Overall Soil Moisture Density')
ax.fill_between(x_dens, density, color='purple', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_42.pdf", bbox_inches="tight")
