
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(2)
months = np.linspace(2010, 2020, 100)  # Simulate months from 2010 to 2020
# Simulated monthly rainfall data for 3 different regions
rainfall_data = [
    100 * np.sin(0.3 * (months - 2010) + i) + 100 + np.random.uniform(-20, 20, 100)
    for i in range(3)
]

# Combine data for density estimation
rainfall_data_1 = rainfall_data[0]
rainfall_data_2 = rainfall_data[1]

# Kernel Density Estimation (KDE) for the rainfall data
kde_rainfall_1 = gaussian_kde(rainfall_data_1, bw_method='scott')
kde_rainfall_2 = gaussian_kde(rainfall_data_2, bw_method='scott')

x_dens_rainfall = np.linspace(0, 200, 1000)
density_rainfall_1 = kde_rainfall_1(x_dens_rainfall)
density_rainfall_2 = kde_rainfall_2(x_dens_rainfall)

# Extracted variables for the density plot
xlabel_text = "Monthly Rainfall (mm)"
ylabel_text = "Density"
title_text = "Density of Monthly Rainfall Trends (2010-2020)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the density curves for rainfall data
ax.plot(x_dens_rainfall, density_rainfall_1, color='blue', lw=2, label='Region 1 Density')
ax.fill_between(x_dens_rainfall, density_rainfall_1, color='blue', alpha=0.3)

ax.plot(x_dens_rainfall, density_rainfall_2, color='green', lw=2, label='Region 2 Density')
ax.fill_between(x_dens_rainfall, density_rainfall_2, color='green', alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc='upper right')

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_45.pdf", bbox_inches="tight")
