# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(0)
time = np.linspace(0, 24, 240)
time_spent_coding = 500 + 200 * np.sin(time / 2.5)
bugs_fixed = 100 + 50 * np.cos(time / 3)
features_added = 300 + 100 * np.sin(time / 4)

# Combine data for density estimation
activity_data_1 = time_spent_coding
activity_data_2 = bugs_fixed
activity_data_3 = features_added

# Kernel Density Estimation (KDE) for the technology activity data
kde_activity_1 = gaussian_kde(activity_data_1, bw_method="scott")
kde_activity_2 = gaussian_kde(activity_data_2, bw_method="scott")
kde_activity_3 = gaussian_kde(activity_data_3, bw_method="scott")

x_dens_activity = np.linspace(0, 1000, 1000)
density_activity_1 = kde_activity_1(x_dens_activity)
density_activity_2 = kde_activity_2(x_dens_activity)
density_activity_3 = kde_activity_3(x_dens_activity)

# Extracted variables for the density plot
xlabel_text = "Count"
ylabel_text = "Density"
title_text = "Density of Technology Activities Over a Day"

labels = ["Time Spent Coding Density", "Bugs Fixed Density", "Features Added Density"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curves for technology activity data
ax.plot(x_dens_activity, density_activity_1, color="blue", lw=2, label=labels[0])
ax.fill_between(x_dens_activity, density_activity_1, color="blue", alpha=0.3)

ax.plot(x_dens_activity, density_activity_2, color="green", lw=2, label=labels[1])
ax.fill_between(x_dens_activity, density_activity_2, color="green", alpha=0.3)

ax.plot(x_dens_activity, density_activity_3, color="orange", lw=2, label=labels[2])
ax.fill_between(x_dens_activity, density_activity_3, color="orange", alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_48.pdf", bbox_inches="tight")
