# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(42)
# Simulated stock prices for three different companies
prices_company_a = np.random.normal(150, 20, 300)
prices_company_b = np.random.normal(250, 25, 300)
prices_company_c = np.random.normal(100, 15, 300)

# Combine data for density estimation
prices_data_1 = prices_company_a
prices_data_2 = prices_company_b
prices_data_3 = prices_company_c

# Kernel Density Estimation (KDE) for the stock prices data
kde_prices_1 = gaussian_kde(prices_data_1, bw_method="scott")
kde_prices_2 = gaussian_kde(prices_data_2, bw_method="scott")
kde_prices_3 = gaussian_kde(prices_data_3, bw_method="scott")

x_dens_prices = np.linspace(
    min(min(prices_data_1), min(prices_data_2), min(prices_data_3)),
    max(max(prices_data_1), max(prices_data_2), max(prices_data_3)),
    1000,
)
density_prices_1 = kde_prices_1(x_dens_prices)
density_prices_2 = kde_prices_2(x_dens_prices)
density_prices_3 = kde_prices_3(x_dens_prices)

# Extracted variables for the density plot
xlabel_text = "Stock Prices"
ylabel_text = "Density"
title_text = "Density of Stock Prices Across Different Companies"
labels = ["Company A Density", "Company B Density", "Company C Density"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 5))

# Plot the density curves for stock prices data
ax.plot(x_dens_prices, density_prices_1, color="purple", lw=2, label=labels[0])
ax.fill_between(x_dens_prices, density_prices_1, color="purple", alpha=0.3)

ax.plot(x_dens_prices, density_prices_2, color="orange", lw=2, label=labels[1])
ax.fill_between(x_dens_prices, density_prices_2, color="orange", alpha=0.3)

ax.plot(x_dens_prices, density_prices_3, color="brown", lw=2, label=labels[2])
ax.fill_between(x_dens_prices, density_prices_3, color="brown", alpha=0.3)

# Set labels and title
ax.set_xlabel(xlabel_text, fontsize=12)
ax.set_ylabel(ylabel_text, fontsize=12)
ax.set_title(title_text, fontsize=16)

# Customize plot border and ticks
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, linestyle=":", alpha=0.5)

# Adding a legend
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output for Density Plot
# ===================
plt.tight_layout()
plt.savefig("density_50.pdf", bbox_inches="tight")
