

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generating new data representing donation amounts to religious organizations
group1_donations = np.random.normal(loc=50, scale=15, size=1000)
group2_donations = np.random.normal(loc=60, scale=20, size=1000)

# Extracted strings
title_text = "Density Distribution of Religious Donations"
xlabel_text = "Donation Amount ($)"
ylabel_text = "Density"
legend_label1 = "Group 1"
legend_label2 = "Group 2"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 7))  # Adjusted for better readability

# Adding a line for the true distribution (assuming normal for illustration)
x = np.linspace(min(group1_donations.min(), group2_donations.min()), max(group1_donations.max(), group2_donations.max()), 300)
group1_pdf = (1 / (np.sqrt(2 * np.pi) * 15)) * np.exp(-((x - 50) ** 2) / (2 * 15**2))
group2_pdf = (1 / (np.sqrt(2 * np.pi) * 20)) * np.exp(-((x - 60) ** 2) / (2 * 20**2))
ax.plot(x, group1_pdf, color='green', linestyle="-", linewidth=2, label=legend_label1)
ax.plot(x, group2_pdf, color='red', linestyle="-", linewidth=2, label=legend_label2)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.grid(True, which='both', linestyle='--', linewidth=0.5)

# Add title and labels
ax.set_title(title_text, fontsize=18)
ax.set_xlabel(xlabel_text, fontsize=16)
ax.set_ylabel(ylabel_text, fontsize=16)
ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_52.pdf", bbox_inches="tight")

