

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Generating new data representing birth years of historical figures
birth_years_18th = np.random.normal(loc=1750, scale=30, size=1000)
birth_years_19th = np.random.normal(loc=1850, scale=25, size=1000)

# Extracted strings
title_text = "Density Distribution of Birth Years"
xlabel_text = "Birth Year"
ylabel_text = "Density"
legend_label1 = "18th Century"
legend_label2 = "19th Century"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 7))  # Adjusted for better readability

# Adding a line for the true distribution
x = np.linspace(min(birth_years_18th.min(), birth_years_19th.min()), max(birth_years_18th.max(), birth_years_19th.max()), 300)
birth_years_18th_pdf = (1 / (np.sqrt(2 * np.pi) * 30)) * np.exp(-((x - 1750) ** 2) / (2 * 30**2))
birth_years_19th_pdf = (1 / (np.sqrt(2 * np.pi) * 25)) * np.exp(-((x - 1850) ** 2) / (2 * 25**2))
ax.plot(x, birth_years_18th_pdf, linestyle="--", linewidth=2, color='teal', label=legend_label1)
ax.plot(x, birth_years_19th_pdf, linestyle="--", linewidth=2, color='seagreen', label=legend_label2)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)

# Add title and labels
ax.set_title(title_text, fontsize=18)
ax.set_xlabel(xlabel_text, fontsize=16)
ax.set_ylabel(ylabel_text, fontsize=16)
ax.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_53.pdf", bbox_inches="tight")
