
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Create historical event data
years = np.linspace(1900, 2000, 100)  # Years from 1900 to 2000
wars_adoption = np.exp(-0.002 * (years - 1940) ** 2)  # Wars peak around 1940
tech_advancements_adoption = np.exp(-0.002 * (years - 1990) ** 2)  # Tech advancements peak around 1990

# Text variables
xlabel_text = "Year"
ylabel_text = "Event Rate"
title_text = "Significant Historical Events Over the Years"
legend_wars = "Wars"
legend_tech_advancements = "Technological Advancements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper left"
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data
ax.fill_between(
    years,
    wars_adoption,
    color="navy",
    edgecolor="darkblue",
    alpha=0.6,
    label=legend_wars,
)
ax.fill_between(
    years,
    tech_advancements_adoption,
    color="forestgreen",
    edgecolor="darkgreen",
    alpha=0.6,
    label=legend_tech_advancements,
)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)
ax.set_ylim(0, 1)

# Add legend
ax.legend(loc=legend_location)

# Adding grid for better readability
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_57.pdf", bbox_inches="tight")
