
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Create technology adoption data
years = np.linspace(2000, 2020, 100)  # Years from 2000 to 2020
smartphone_adoption = 10 + 4 * (years - 2000) + 10 * np.sin(0.3 * (years - 2000))  # Increasing smartphone adoption with fluctuation
wearable_adoption = 3 + 2 * (years - 2000) * np.exp(0.02 * (years - 2010))  # Increasing wearable tech adoption

# Text variables
xlabel_text = "Year"
ylabel_text = "Adoption Rate (%)"
title_text = "Technology Adoption Rates Over the Years"
legend_smartphone_adoption = "Smartphone Adoption"
legend_wearable_adoption = "Wearable Tech Adoption"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper left"
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the data
ax.fill_between(
    years,
    smartphone_adoption,
    color="#1f77b4",
    edgecolor="#1f77b4",
    alpha=0.6,
    label=legend_smartphone_adoption,
)
ax.fill_between(
    years,
    wearable_adoption,
    color="#2ca02c",
    edgecolor="#2ca02c",
    alpha=0.6,
    label=legend_wearable_adoption,
)

# Customize the plot
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)
ax.tick_params(left=True, labelleft=True, bottom=True, labelbottom=True)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)
ax.set_ylim(0, 100)  # Adjust y-limit for percentage
ax.set_facecolor("#f9f9f9")
ax.grid(True, linestyle='--', alpha=0.7)

# Add legend
ax.legend(loc=legend_location)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_58.pdf", bbox_inches="tight")
