

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

# Set random seed for reproducibility
np.random.seed(200)

# Generate a log-normal distribution simulating income levels
log_mean = 10
log_sigma = 1
income_data = np.random.lognormal(log_mean, log_sigma, 1000)
xs = np.linspace(0, 100000, 500)

# Axes Limits and Labels
title = "KDE Plot of Income Distribution"
xlabel_value = "Income Amount (in dollars)"
ylabel_value = "Density"

xticks_values = [0, 20000, 40000, 60000, 80000, 100000]
xticklabels = ["0", "20K", "40K", "60K", "80K", "100K"]
yticks_values = [0, 0.00001, 0.00002, 0.00003, 0.00004, 0.00005]
yticklabels = ["0.0", "0.00001", "0.00002", "0.00003", "0.00004", "0.00005"]
xlim_values = [0, 100000]
ylim_values = [0, 0.00006]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Set the figure size
fig, ax = plt.subplots(figsize=(10, 5))

# Create the KDE plot with adjusted x-axis range
density = gaussian_kde(income_data)
density.covariance_factor = lambda: 0.25
density._compute_covariance()
plt.fill_between(xs, density(xs), color="#a2d5c6", edgecolor="#4b9b8a")

ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels)

ax.set_yticks(yticks_values)
ax.set_yticklabels(yticklabels)

plt.xlim(xlim_values)
plt.ylim(ylim_values)
# Set the title and labels
plt.title(title, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_65.pdf", bbox_inches="tight")
