
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for systolic blood pressure readings in three age groups
young_adults_bp = np.random.normal(loc=120, scale=10, size=1500)
middle_aged_bp = np.random.normal(loc=130, scale=15, size=1500)
seniors_bp = np.random.normal(loc=140, scale=20, size=1500)
labels = ["Young Adults BP", "Middle-Aged BP", "Seniors BP"]
avxlabel = "Average Healthy BP"
xlabel = "Systolic Blood Pressure (mmHg)"
ylabel = "Density"
title = "Density Plot of Systolic Blood Pressure Readings by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(9, 6))

# Updated color scheme
colors = ["#FF5733", "#33FFBD", "#337BFF"]

# Plot the density plots
for data, color, label in zip(
    [young_adults_bp, middle_aged_bp, seniors_bp],
    colors,
    labels,
):
    density = gaussian_kde(data)
    xs = np.linspace(80.0, 200.0, 200)
    density.covariance_factor = lambda: 0.4
    density._compute_covariance()
    plt.fill_between(xs, density(xs), color=color, alpha=0.3, label=label)
    plt.plot(xs, density(xs), color=color, linewidth=2)

# Plot the average healthy blood pressure line
plt.axvline(x=120.0, color="orange", linestyle="--", linewidth=2, label=avxlabel)

# Set labels and title (if any)
ax.set_xlim(80.0, 200.0)
ax.set_xticks(range(80, 201, 20))
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle="--", linewidth=0.7, alpha=0.7)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("density_74.pdf", bbox_inches="tight")
