
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(43)
# Sample data
renewable_energy = np.random.normal(loc=60, scale=15, size=1000)
non_renewable_energy = np.random.normal(loc=120, scale=20, size=1000)

# Compute density for each dataset
density_renewable = gaussian_kde(renewable_energy)
density_non_renewable = gaussian_kde(non_renewable_energy)
xs = np.linspace(0, 200, 300)
ys_renewable = density_renewable(xs)
ys_non_renewable = density_non_renewable(xs)

# Labels and texts
labels = ["Renewable Energy", "Non-Renewable Energy"]
xlabel = "Energy Consumption (MWh)"
ylabel = "Density"
title = "Monthly Energy Consumption Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (0, 200)
grid_style = ":"

# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Fill between x for density regions
plt.fill_between(xs, ys_renewable, color="#ff9999", alpha=0.5, label=labels[0])
plt.fill_between(xs, ys_non_renewable, color="#66b3ff", alpha=0.5, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
plt.grid(True, linestyle=grid_style)

# Add legend
plt.legend(loc='upper right', fontsize=11, frameon=True, shadow=True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_75.pdf", bbox_inches="tight")
