
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(76)

# Sample data - Population Domain
region1_population = np.random.normal(loc=50000, scale=8000, size=1000)
region2_population = np.random.normal(loc=30000, scale=5000, size=1000)

# Compute density for each dataset
density_region1 = gaussian_kde(region1_population)
density_region2 = gaussian_kde(region2_population)
xs = np.linspace(10000, 70000, 300)
ys_region1 = density_region1(xs)
ys_region2 = density_region2(xs)

# Labels and texts
labels = ["Region 1", "Region 2"]
xlabel = "Population"
ylabel = "Density"
title = "Distribution of Population in Two Regions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xlim = (10000, 70000)
grid_style = "--"

# Create the figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Fill between x for density regions
plt.fill_between(xs, ys_region1, color="#1f77b4", alpha=0.5, label=labels[0])
plt.fill_between(xs, ys_region2, color="#ff7f0e", alpha=0.5, label=labels[1])

# Set labels and title (if any)
ax.set_xlim(xlim)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
plt.grid(True, linestyle=grid_style)

# Add legend
plt.legend(loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_76.pdf", bbox_inches="tight")
