
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Reproducibility
import numpy as np
from scipy.stats import gaussian_kde

np.random.seed(80)
# Simulated weather data
temperature = np.random.normal(loc=75, scale=10, size=1000)
humidity = np.random.normal(loc=50, scale=20, size=1000)
wind_speed = np.random.normal(loc=10, scale=5, size=1000)

# Compute density for each dataset
density1 = gaussian_kde(temperature)
density2 = gaussian_kde(humidity)
density3 = gaussian_kde(wind_speed)
xs = np.linspace(0, 100, 400)
ys1 = density1(xs)
ys2 = density2(xs)
ys3 = density3(xs)

# Labels
labels = ["Temperature", "Humidity", "Wind Speed"]
xlabel = "Measurement Values"
ylabel = "Density"
title = "Density Plot of Weather Data"
peak_annotation = "Peak: {}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
grid_style = "--"
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Fill between x for density regions with optimization
plt.fill_between(xs, ys1, color="skyblue", alpha=0.5, label=labels[0])
plt.fill_between(xs, ys2, color="lightgreen", alpha=0.5, label=labels[1])
plt.fill_between(xs, ys3, color="lightcoral", alpha=0.5, label=labels[2])

# Plot lines for densities
plt.plot(xs, ys1, color="blue", linestyle=(0, (5, 1)), linewidth=2)
plt.plot(xs, ys2, color="green", linestyle=(0, (3, 1, 1, 1)), linewidth=2)
plt.plot(xs, ys3, color="red", linestyle=(0, (1, 1)), linewidth=2)

# Set labels and title (if any)
ax.set_xlim(0, 100)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Annotations for peaks
peak1 = xs[np.argmax(ys1)]
peak2 = xs[np.argmax(ys2)]
peak3 = xs[np.argmax(ys3)]
plt.annotate(
    peak_annotation.format(int(peak1)),
    xy=(peak1, max(ys1)),
    xytext=(peak1 + 5, max(ys1) - 0.005),
    arrowprops=dict(facecolor="black", shrink=0.05),
)
plt.annotate(
    peak_annotation.format(int(peak2)),
    xy=(peak2, max(ys2)),
    xytext=(peak2 + 5, max(ys2) + 0.005),
    arrowprops=dict(facecolor="black", shrink=0.05),
)
plt.annotate(
    peak_annotation.format(int(peak3)),
    xy=(peak3, max(ys3)),
    xytext=(peak3 + 5, max(ys3) - 0.005),
    arrowprops=dict(facecolor="black", shrink=0.05),
)

# Show grid
plt.grid(True, linestyle=grid_style)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("density_80.pdf", bbox_inches="tight")
