

# ======================
# Part 1: Importing Libraries
# ======================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
individuals = ["Alice", "Bob", "Charlie", "Diana"]
professional_ratings = [85, 78, 92, 75]
casual_ratings = [90, 82, 88, 80]
error_professional = [5, 7, 6, 8]  # Error values for professional ratings
error_casual = [6, 8, 5, 7]  # Error values for casual ratings
x = np.arange(len(professional_ratings))  # x-coordinates for the bars
labels = ["Professional Context", "Casual Context"]
title = "Communication Skills Ratings of Different Individuals"
ylims = [[0, 100], [0,100]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Color scheme
color_professional = "#5A9BD5"
color_casual = "#67BABA"

# Set the figure size
fig, ax1 = plt.subplots(figsize=(8, 5))
# Bar width
width = 0.35

# Plotting 'professional_ratings' on the primary y-axis
bars1 = ax1.bar(
    x - width / 2,
    professional_ratings,
    width,
    label=labels[0],
    color=color_professional,
    yerr=error_professional,
    capsize=5,
    edgecolor="black",
)

# Create the secondary y-axis for 'casual_ratings'
ax2 = ax1.twinx()
bars2 = ax2.bar(
    x + width / 2,
    casual_ratings,
    width,
    label=labels[1],
    color=color_casual,
    yerr=error_casual,
    capsize=5,
    edgecolor="black",
)

# Adding annotations directly on the bars for clarity
for i, bar in enumerate(bars1):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax1.text(
        label_x_pos,
        height - error_professional[i] - 1,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )
for j, bar in enumerate(bars2):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax2.text(
        label_x_pos,
        height - error_casual[j] - 1,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )

fig.suptitle(title)
# Adding labels, title, and custom x-axis tick labels
ax1.set_ylabel(labels[0], color=color_professional)
ax2.set_ylabel(labels[1], color=color_casual)
ax1.set_xticks(x)
ax1.set_xticklabels(individuals)

# Add a horizontal line at y=0 if needed
ax1.axhline(0, color="grey", linewidth=0.8)

# Adjusting y-axis limits to fit the annotations and errors
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Adding grid lines for better readability
ax1.yaxis.grid(linestyle="--", linewidth="0.5", color="grey")
ax1.set_axisbelow(True)

ax2.yaxis.grid(linestyle="--", color="grey")
ax2.set_axisbelow(True)
# Adding legend
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=2)

# ======================
# Part 4: Saving Output
# ======================
# Adjust layout
plt.tight_layout()
plt.savefig("errorbar_103.pdf", bbox_inches="tight")

