
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
farms = ["Farm A", "Farm B", "Farm C", "Farm D"]
crop_yield_growth = [5.6, 7.8, 4.2, 9.1]
water_usage_efficiency = [12.3, 15.4, 11.1, 16.7]
error_crop_yield_growth = [0.5, 0.6, 0.4, 0.7]
error_water_usage_efficiency = [1.0, 1.2, 0.9, 1.3]

x = np.arange(len(crop_yield_growth))  # x-coordinates for the bars
labels = ["Crop Yield Growth (%)", "Water Usage Efficiency (%)"]
title = "Agricultural Performance of Farms"
ylims = [[0, 10], [0, 20]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax1 = plt.subplots(figsize=(10, 6))
# Bar width
width = 0.35

# Plotting 'crop_yield_growth' on the primary y-axis
bars1 = ax1.bar(
    x - width / 2,
    crop_yield_growth,
    width,
    label=labels[0],
    color="#4CAF50",  # Green color for growth
    yerr=error_crop_yield_growth,
    capsize=5,
    edgecolor="black",
)

# Create the secondary y-axis for 'water_usage_efficiency'
ax2 = ax1.twinx()
bars2 = ax2.bar(
    x + width / 2,
    water_usage_efficiency,
    width,
    label=labels[1],
    color="#2196F3",  # Blue color for stability
    yerr=error_water_usage_efficiency,
    capsize=5,
    edgecolor="black",
)

# Adding annotations directly on the bars for clarity
for i, bar in enumerate(bars1):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax1.text(
        label_x_pos,
        height - error_crop_yield_growth[i] - 0.5,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )
for j, bar in enumerate(bars2):
    height = bar.get_height()
    label_x_pos = bar.get_x() + bar.get_width() / 2
    ax2.text(
        label_x_pos,
        height - error_water_usage_efficiency[j] - 0.3,
        f"{height}%",
        rotation=90,
        ha="center",
        va="bottom" if height < 0 else "top",
    )

fig.suptitle(title)
# Adding labels, title, and custom x-axis tick labels
ax1.set_ylabel(labels[0], color="#4CAF50")
ax2.set_ylabel(labels[1], color="#2196F3")
ax1.set_xticks(x)
ax1.set_xticklabels(farms)

# Add a horizontal line at y=0 if needed
ax1.axhline(0, color="grey", linewidth=0.8)

# Adjusting y-axis limits to fit the annotations and errors
ax1.set_ylim(ylims[0])
ax2.set_ylim(ylims[1])

# Adding grid lines for better readability
ax1.yaxis.grid(linestyle="--", linewidth="0.5", color="grey")
ax1.set_axisbelow(True)

ax2.yaxis.grid(linestyle="--", color="grey")
ax2.set_axisbelow(True)

# Adding legend
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("errorbar_104.pdf", bbox_inches="tight")
