
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data
user_groups = [
    "Gamers",
    "Developers",
    "Designers",
    "Managers",
    "Students",
    "Teachers",
    "Researchers",
    "Freelancers",
    "Bloggers",
    "Marketers",
]
satisfaction_index = [
    8.2,
    7.6,
    7.9,
    6.8,
    7.4,
    7.0,
    7.2,
    7.5,
    7.9,
    8.1,
]
errors = [0.4] * 10  # Assuming constant error for all bars
legendtitle = ["High Satisfaction", "Moderate Satisfaction"]
ylabel = "Average Satisfaction Index ↑"
xlabel = "User Groups"
title = "Tech Product Satisfaction Across Different User Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6", "#c4e17f", "#76d7c4", "#ff7f50", "#8e44ad"]
fig, ax = plt.subplots(figsize=(8, 6))
bars = ax.bar(
    user_groups,
    satisfaction_index,
    yerr=errors,
    color=colors,
    capsize=10,
    error_kw={
        "ecolor": "darkgray",
        "elinewidth": 2,
        "capsize": 5,
        "capthick": 2,
    },
)

# Annotate bars with satisfaction index values
for bar, satisfaction, error, group in zip(bars, satisfaction_index, errors, user_groups):
    ax.text(
        bar.get_x() + bar.get_width() / 2,
        bar.get_height() - error - 0.1,
        f"{satisfaction:.1f}",
        ha="center",
        va="bottom",
    )

# Legend setup
high_satisfaction_patch = mpatches.Patch(color="#ff9999", label=legendtitle[0])
moderate_satisfaction_patch = mpatches.Patch(color="#66b3ff", label=legendtitle[1])
ax.legend(handles=[high_satisfaction_patch, moderate_satisfaction_patch], loc="upper right", frameon=False)

# Labels and grid
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_ylim(6.0, 9.0)
ax.yaxis.grid(True)
ax.set_axisbelow(True)
plt.xticks(rotation=45, ha='right')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_32.pdf", bbox_inches="tight")
