

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Example data for religious affiliations and attendance levels
groups = [
    "Christianity / Regular / North America",
    "Christianity / Regular / Europe",
    "Christianity / Regular / Asia",
    "Christianity / Irregular / North America",
    "Christianity / Irregular / Europe",
    "Christianity / Irregular / Asia",
    "Islam / Regular / North America",
    "Islam / Regular / Europe",
    "Islam / Regular / Asia",
    "Islam / Irregular / North America",
    "Islam / Irregular / Europe",
    "Islam / Irregular / Asia",
    "Hinduism / Regular / North America",
    "Hinduism / Regular / Europe",
    "Hinduism / Regular / Asia",
    "Hinduism / Irregular / North America",
    "Hinduism / Irregular / Europe",
    "Hinduism / Irregular / Asia",
]
solid_bar_values = np.random.rand(18) * 100  # Attendance Rate
striped_bar_values = np.random.rand(18) * 100  # Community Engagement Score
error = np.random.rand(18) * 5  # Error margins

# Labels and Plot Types
label_Striped = "Community Engagement"
label_Solid = "Attendance Rate"

# Axes Limits and Labels
xlabel_value = "Score"
ylabel_value = "Religious Affiliation / Attendance Level / Region"
title = "Religious Affiliation and Attendance Metrics"
ylim_values = [-0.5, 17.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(12, 10))

# Colors for bars
color_Striped = "#8ecae6"
color_Solid = "#fb8500"

# Create grouped bar chart with error bars
bar_width = 0.4
index = np.arange(len(groups))
plt.barh(
    index - 0.2,
    striped_bar_values,
    bar_width,
    color=color_Striped,
    hatch="..",
    xerr=error,
    label=label_Striped,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)
plt.barh(
    index + 0.2,
    solid_bar_values,
    bar_width,
    color=color_Solid,
    hatch="xx",
    xerr=error,
    label=label_Solid,
    capsize=3,
    edgecolor="black",
    alpha=0.8,
)

# Add labels and title
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_ylim(ylim_values)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorbar_37.pdf", bbox_inches="tight")

