
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # For reproducibility

# Data
sports = ["Football", "Basketball", "Tennis", "Swimming", "Running"]
training_hours_means = [10, 12, 8, 15, 5]
training_hours_errors = [1.5, 2, 1, 2.5, 0.5]
injury_incidence_means = [20, 15, 5, 2, 8]  # per 1000 hours
injury_incidence_errors = [3, 4, 1, 0.5, 1.5]

ylabel1 = "Average Training Hours per Week"
xlabel1 = "(a) Training Hours for Different Sports"
ylabel2 = "Injury Incidence (per 1000 hours)"
xlabel2 = "(b) Injury Incidence for Different Sports"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))  # Adjusted for better dimensions
colors = ["#4e79a7", "#f28e2b", "#e15759", "#76b7b2", "#59a14f"]

# Training hours for different sports
ax1.bar(sports, training_hours_means, yerr=training_hours_errors, color=colors, capsize=5)
ax1.set_ylabel(ylabel1)
ax1.set_xlabel(xlabel1)
for i, v in enumerate(training_hours_means):
    ax1.text(i, v + training_hours_errors[i] + 0.5, str(v), ha="center", va="bottom")
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.yaxis.grid(True)
ax1.set_axisbelow(True)

# Injury incidence for different sports
ax2.bar(sports, injury_incidence_means, yerr=injury_incidence_errors, color=colors, capsize=5)
ax2.set_ylabel(ylabel2)
ax2.set_xlabel(xlabel2)
for i, v in enumerate(injury_incidence_means):
    ax2.text(i, v + injury_incidence_errors[i] + 0.5, str(v), ha="center", va="bottom")

ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.yaxis.grid(True)
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_41.pdf", bbox_inches="tight")
