
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Data
sports = ["Soccer", "Basketball", "Tennis", "Baseball", "Swimming"]
average_performance = [30.2, 25.4, 15.8, 22.1, 20.0]
performance_errors = [3.5, 4.2, 2.9, 3.7, 3.1]
average_training_hours = [10.5, 12.3, 8.9, 9.6, 14.0]
training_hours_errors = [2.1, 2.5, 1.8, 2.0, 2.8]

ylabel1 = "Average Performance (Goals, Points, Wins)"
xlabel1 = "(a) Average Performance in Different Sports"
ylabel2 = "Average Training Hours per Week"
xlabel2 = "(b) Average Training Hours per Week in Different Sports"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 4))

colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]

# Average performance of sports
ax1.bar(sports, average_performance, yerr=performance_errors, color=colors, capsize=5)
ax1.set_ylabel(ylabel1)
ax1.set_xlabel(xlabel1)
for i, v in enumerate(average_performance):
    ax1.text(i, v + performance_errors[i] + 1, str(v), ha="center", va="bottom")
ax1.spines["top"].set_visible(False)
ax1.spines["right"].set_visible(False)
ax1.yaxis.grid(True)
ax1.set_axisbelow(True)

# Average training hours of sports
ax2.bar(sports, average_training_hours, yerr=training_hours_errors, color=colors, capsize=5)
ax2.set_ylabel(ylabel2)
ax2.set_xlabel(xlabel2)
for i, v in enumerate(average_training_hours):
    ax2.text(i, v + training_hours_errors[i] + 1, str(v), ha="center", va="bottom")
ax2.spines["top"].set_visible(False)
ax2.spines["right"].set_visible(False)
ax2.yaxis.grid(True)
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_42.pdf", bbox_inches="tight")
