

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the left plot (Average Life Expectancy by Region)
left_categories = [
    "North America",
    "South America",
    "Europe",
    "Africa",
    "Asia",
    "Australia",
    "Antarctica",
]
left_means = [79.0, 75.3, 82.1, 64.4, 74.6, 81.2, 50.5]  # Average life expectancy in years
left_errors = [1.5, 1.2, 1.3, 2.1, 1.1, 1.5, 3.5]

# Data for the right plot (Average Literacy Rate by Region)
right_categories = [
    "North America",
    "South America",
    "Europe",
    "Africa",
    "Asia",
    "Australia",
    "Antarctica",
]
right_means = [99, 94, 98, 75, 90, 97, 50]  # Average literacy rate in percentage
right_errors = [1, 2, 1, 5, 3, 2, 10]

# Chart Labels
title1 = "Average Life Expectancy by Region (Years)"
ylabel1 = "Life Expectancy (Years)"
ylim1 = [40, 90]
yticks1 = np.arange(50, 91, 10)
title2 = "Average Literacy Rate by Region (%)"
ylabel2 = "Literacy Rate (%)"
ylim2 = [0, 110]
yticks2 = np.arange(0, 101, 20)
suptitle = "Societal Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Colors for the left plot bars
left_colors = ["#FF5733", "#FF8D1A", "#FFB100", "#FFD700", "#FFE700", "#FFF700", "#B0E57C"]

# Left plot (Average Life Expectancy)
ax1.bar(
    left_categories,
    left_means,
    yerr=left_errors,
    color=left_colors,
    capsize=5,
    error_kw=dict(ecolor="black", lw=1.5, capsize=5, capthick=2),
)
ax1.set_title(title1)
ax1.set_ylabel(ylabel1)
ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)
ax1.set_xticklabels(left_categories, rotation=45, ha="right")
ax1.tick_params(axis="both", length=4)
ax1.grid(True, linestyle='--', alpha=0.6)
ax1.set_axisbelow(True)
for spine in ax1.spines.values():
    spine.set_color("gray")

# Colors for the right plot bars
right_colors = ["#1E90FF", "#00BFFF", "#00CED1", "#20B2AA", "#48D1CC", "#40E0D0", "#5F9EA0"]

# Right plot (Average Literacy Rate)
ax2.bar(
    right_categories,
    right_means,
    yerr=right_errors,
    color=right_colors,
    capsize=5,
    error_kw=dict(ecolor="black", lw=1.5, capsize=5, capthick=2),
)
ax2.set_title(title2)
ax2.set_ylabel(ylabel2)
ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_xticklabels(right_categories, rotation=45, ha="right")
ax2.tick_params(axis="both", length=4)
ax2.grid(True, linestyle='--', alpha=0.6)
ax2.set_axisbelow(True)

# Set the title for the entire figure
fig.suptitle(suptitle, fontsize=16)

for spine in ax2.spines.values():
    spine.set_color("gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("errorbar_48.pdf", bbox_inches="tight")

