
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data for Population Analysis
countries = [
    "USA",
    "China",
    "Germany",
    "India",
    "UK",
    "France",
    "Brazil",
    "Canada",
    "Japan",
]
population_growth = [0.7, 0.5, 0.2, 1.0, 0.3, 0.4, 0.8, 0.6, 0.1]
urbanization_growth = [0.8, 2.0, 0.4, 2.5, 0.5, 0.6, 1.5, 0.7, 0.2]
error = [0.2, 0.3, 0.1, 0.4, 0.2, 0.2, 0.3, 0.2, 0.1]
labels = ["Population Growth Rate (%)", "Urbanization Growth Rate (%)"]
ylabel = "Growth Rate (%)"
ylim = [0, 3]
yticks = np.arange(0, 4, 0.5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 5))
# Bar width
bar_width = 0.35

# X position of bars
r1 = np.arange(len(population_growth))
r2 = [x + bar_width for x in r1]

# Create bars
plt.bar(
    r1,
    population_growth,
    color="#4caf50",
    width=bar_width,
    label=labels[0],
    yerr=error,
    capsize=7,
)
plt.bar(
    r2,
    urbanization_growth,
    color="#2196f3",
    width=bar_width,
    label=labels[1],
    yerr=error,
    capsize=7,
)

# Add xticks on the middle of the group bars
plt.xticks([r + bar_width / 2 for r in range(len(population_growth))], countries)

# Create legend & Show graphic
plt.ylabel(ylabel)
plt.legend(frameon=False, loc="upper left")  # Remove legend background

# Set background color and grid
plt.gca().set_facecolor("#f0f0f0")
plt.grid(color="white", linestyle="-", linewidth=0.5, axis="both")
plt.gca().set_axisbelow(True)

# Set y-axis limits
plt.ylim(ylim)
plt.yticks(yticks)

for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_52.pdf", bbox_inches="tight")
