# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = [
    "Listening",
    "Speaking",
    "Writing",
    "Non-Verbal",
    "Cross-Cultural",
    "Team\nCommunication",
    "Presentation",
    "Conflict\nResolution",
    "Overall\nCommunication",
]
ground_truth_ratings = [88, 82, 85, 90, 87, 86, 89, 84, 88]
weak_labels_ratings = [80, 78, 83, 85, 80, 81, 83, 79, 81]
error = [4, 5, 4, 5, 4, 4, 5, 4, 3]

# Labels and title
labels = ["Supervisor Ratings", "Self-Assessments"]
xlabel = "Communication Skills"
ylabel = "Performance Ratings (%)"
title = "Comparison of Communication Skill Ratings"
ylim = [70, 95]
yticks = np.arange(70, 96, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.subplots(figsize=(12, 6))
# Bar width
bar_width = 0.35

# X position of bars
r1 = np.arange(len(ground_truth_ratings))
r2 = [x + bar_width for x in r1]

# Create bars
plt.bar(
    r1,
    ground_truth_ratings,
    color="#4CAF50",  # Green color
    width=bar_width,
    label=labels[0],
    yerr=error,
    capsize=7,
)
plt.bar(
    r2,
    weak_labels_ratings,
    color="#FF9800",  # Orange color
    width=bar_width,
    label=labels[1],
    yerr=error,
    capsize=7,
)

# Add xticks on the middle of the group bars
plt.xticks([r + bar_width / 2 for r in range(len(ground_truth_ratings))], categories)

# Create legend & Show graphic
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend(frameon=False, loc="upper right")  # Remove legend background

# Set background color and grid
plt.gca().set_facecolor("#f5f5f5")
plt.grid(color="white", linestyle="-", linewidth=0.75, axis="y")
plt.gca().set_axisbelow(True)

# Set y-axis limits
plt.ylim(ylim)
plt.yticks(yticks)

for spine in plt.gca().spines.values():
    spine.set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_54.pdf", bbox_inches="tight")
