
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = [2019, 2020, 2021, 2022]
baseline_temp = [15] * len(years)
avg_temp_2019 = [10, 12, 15, 13]
avg_temp_2020 = [11, 13, 16, 14]
errors_temp = [1, 1.5, 1, 0.5]

# Labels and Plot Types
label1 = "Average Temp 2019"
label2 = "Average Temp 2020"
label3 = "Baseline Temp"

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value = "Average Seasonal Temperature (°C)"
title = "Average Seasonal Temperatures Over Years"
xticklabels = ["2019", "2020", "2021", "2022"]
ylim_values = [8, 18]
yticks_values = np.arange(8, 20, 2)
legend_title = "Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusted for the given dimensions
bar_width = 0.4
opacity = 0.8

bar1 = ax.bar(
    np.array(years) - bar_width / 2,
    avg_temp_2019,
    bar_width,
    alpha=opacity,
    color="#ff9999",
    label=label1,
    yerr=errors_temp,
    capsize=5,
)

bar2 = ax.bar(
    np.array(years) + bar_width / 2,
    avg_temp_2020,
    bar_width,
    alpha=opacity,
    color="#66b3ff",
    label=label2,
    yerr=errors_temp,
    capsize=5,
)

ax.plot(
    years,
    baseline_temp,
    linestyle="--",
    color="#ffcc99",
    linewidth=2,
    label=label3,
)

ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title)
ax.set_xticks(years)
ax.set_xticklabels(xticklabels)
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.legend(loc="upper right", title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_60.pdf", bbox_inches="tight")
