
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
regions = ["Region X", "Region Y", "Region Z"]
rainfall_2019 = [120, 135, 128]
rainfall_2020 = [125, 140, 133]
rainfall_2021 = [130, 145, 138]
error = [7, 5, 6]

# Bar positions
x = np.arange(len(regions))
width = 0.25
labels = ["2019 Rainfall", "2020 Rainfall", "2021 Rainfall"]
ylabel = "Average Monthly Rainfall (mm)"
title = "Average Monthly Rainfall by Region (2019-2021)"
ylim = [100, 160]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))

bars1 = ax.bar(
    x - width,
    rainfall_2019,
    width,
    label=labels[0],
    color="#93c4f2",
    hatch="\\",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="gray"),
)
bars2 = ax.bar(
    x,
    rainfall_2020,
    width,
    label=labels[1],
    color="#76b041",
    hatch="//",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="gray"),
)
bars3 = ax.bar(
    x + width,
    rainfall_2021,
    width,
    label=labels[2],
    color="#7f8c8d",
    hatch="o",
    yerr=error,
    capsize=5,
    error_kw=dict(ecolor="gray"),
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xticks(x)
ax.set_xticklabels(regions)
ax.set_ylim(ylim)
ax.legend(loc="upper center", ncol=3, fontsize=10)

# Adding the data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            "{}".format(round(height, 1)),
            xy=(bar.get_x() + bar.get_width() / 2, height + error[bars.index(bar)]),
            xytext=(0, 3),
            textcoords="offset points",
            ha="center",
            va="bottom",
            fontsize=10
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# Adding grid
ax.grid(True, which='both', linestyle='--', linewidth=0.5, color='gray', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_63.pdf", bbox_inches="tight")
