
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
means = [np.random.uniform(-5, 5, 3) for _ in range(4)]
errors = [np.random.uniform(0.5, 1.5, 3) for _ in range(4)]

# Labels
labels = ["City A", "City B", "City C", "City D"]
x = np.arange(len(labels) - 1)  # Adjusted to have 3 bars instead of 4

label_s = [
    ["City B", "City C", "City D"],
    ["City A", "City C", "City D"],
    ["City A", "City B", "City C"],
    ["City A", "City B", "City D"],
]
title = "Average Monthly Temperature Change (in °C)"
xlabel = "Comparative Cities"
ylabel = "Temperature Change (°C)"
ylim = [-6, 6]
yticks = [i for i in range(-6, 7, 2)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(
    2, 2, figsize=(10, 6)
)

# Define colors for each bar
colors = [
    ["#4C72B0", "#55A868", "#C44E52"],  # muted blue, green, red
    ["#8172B2", "#64B5CD", "#CCB974"],  # muted purple, cyan, brown
    ["#4C72B0", "#55A868", "#C44E52"], 
    ["#8172B2", "#64B5CD", "#CCB974"],
]

# Loop through each subplot to set properties
for i, ax in enumerate(axs.flat):
    ax.bar(
        x,
        means[i],
        yerr=errors[i],
        color=colors[i],
        edgecolor="white",
        label=label_s[i],
    )
    ax.set_xlabel(f"{labels[i]} {xlabel}")
    ax.set_xticks([])
    for spine in ax.spines.values():
        spine.set_visible(False)
    ax.set_ylim(ylim)
    ax.set_yticks(yticks)
    ax.set_facecolor("#f5f5f5")
    ax.yaxis.grid(color="white", linestyle="-", linewidth=1)
    ax.set_axisbelow(True)
    ax.tick_params(axis="both", length=0)

# Set the ylabel for the first column plots
for ax in axs[:, 0]:
    ax.set_ylabel(ylabel)

# Add a supertitle
fig.suptitle(title, fontsize=16)

# Adjust layout
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

# Legend
fig.legend(
    labels,
    loc="lower center",
    ncol=4,
    bbox_to_anchor=(0.5, -0.1),
    facecolor="#f5f5f5",
)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("errorbar_64.pdf", bbox_inches="tight")
