

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for seasonal temperature variations
means = [np.random.uniform(-10, 30, 3) for m in range(4)]
errors = [np.random.randint(1, 5, 3) for n in range(4)]

# Labels
labels = ["Winter", "Spring", "Summer", "Autumn"]
x = np.arange(len(labels) - 1)  # Adjusted to have 3 bars instead of 4

label_s = [
    ["Morning", "Afternoon", "Evening"],
    ["Morning", "Afternoon", "Evening"],
    ["Morning", "Afternoon", "Evening"],
    ["Morning", "Afternoon", "Evening"],
]
title = "Seasonal Temperature Metrics"
xlabel = "Measurement Type"
ylim = [-15, 35]
yticks = [-15, -5, 5, 15, 25, 35]
legends = ["Morning", "Afternoon", "Evening"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(
    2, 2, figsize=(10, 6)
)  # Slightly larger to accommodate more data
# Define colors for each bar
colors = [
    ["#FF6F61", "#6B5B95", "#88B04B"],
    ["#F7CAC9", "#92A8D1", "#034F84"],
    ["#F7786B", "#DE7A22", "#F4A7B9"],
    ["#45B8AC", "#EFC050", "#5B5EA6"],
]


# Loop through each subplot to set properties
for i, ax in enumerate(axs.flat):
    bars = ax.bar(
        x,
        means[i],
        yerr=errors[i],
        color=colors[i],
        edgecolor="gray",
        capsize=5,
        label=label_s[i],
    )
    ax.set_xlabel(f"{labels[i]} {xlabel}")
    ax.set_xticks([])
    for spine in ax.spines.values():
        spine.set_visible(False)
    ax.set_ylim(ylim)
    ax.set_yticks(yticks)
    ax.set_facecolor("#FAF9F6")
    ax.yaxis.grid(color="#CCCCCC", linestyle="--", linewidth=1)
    ax.set_axisbelow(True)
    ax.tick_params(axis="both", length=0)

fig.legend(
    legends,
    loc="lower center",
    ncol=3,
    bbox_to_anchor=(0.5, -0.15),
    title=title,
    facecolor="#FAF9F6",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
# Legend
plt.savefig("errorbar_65.pdf", bbox_inches="tight")
