
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Elephants",
    "Pandas",
    "Tigers",
    "Rhinos",
][::-1]

subcategories = ["Population Growth", "Habitat Area", "Endangerment Level", "Protection Efforts"][::-1]

values = [
    [0.50, 0.35, 0.70, 0.60],  # Elephants
    [0.40, 0.50, 0.60, 0.75],  # Pandas
    [0.30, 0.25, 0.80, 0.65],  # Tigers
    [0.20, 0.15, 0.90, 0.70],  # Rhinos
]

errors = [
    [0.04, 0.03, 0.02, 0.03],
    [0.03, 0.02, 0.02, 0.01],
    [0.02, 0.01, 0.01, 0.02],
    [0.01, 0.01, 0.01, 0.02],
]

percentages = [
    "+5.0%", "+3.5%", "+7.0%", "+6.0%",
    "+4.0%", "+5.0%", "+6.0%", "+7.5%",
    "+3.0%", "+2.5%", "+8.0%", "+6.5%",
    "+2.0%", "+1.5%", "+9.0%", "+7.0%",
][::-1]

xlim = [0.1, 1.0]

# Labels
xlabel = "Conservation Metric Value"
fig_title = "Wildlife Conservation Metrics Analysis"
subtitle = "Comparison of various animal species"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axes = plt.subplots(4, 1, figsize=(10, 12), sharex=True)
# Colors
colors = ["#F08080", "#87CEEB", "#98FB98", "#FFD700"]

for i, ax in enumerate(axes):
    ax.barh(subcategories, values[i][::-1], xerr=errors[i], color=colors[i], capsize=5, edgecolor='black')
    ax.set_yticklabels(subcategories)
    ax.set_xlim(xlim)
    ax.set_ylabel(categories[i], fontsize=12, fontweight='bold')
    for j, v in enumerate(values[i][::-1]):
        ax.text(v + errors[i][j] + 0.02, j, percentages[i * 4 + j], color="black", va="center", fontsize=10, fontweight='bold')

# X-axis label and title
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.suptitle(fig_title, fontsize=16, fontweight='bold')
plt.title(subtitle, fontsize=12, fontweight='regular')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save
plt.tight_layout(rect=[0, 0.03, 1, 0.95])
plt.savefig("errorbar_67.pdf", bbox_inches="tight")
