

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for legal domain
categories = [
    "Criminal Case",
    "Civil Case",
    "Family Law",
    "Corporate Case",
][::-1]
subcategories = ["Case Duration", "Resolution Rate", "Client Satisfaction", "Success Rate"][::-1]
values = [
    [0.80, 0.72, 0.90, 0.84],
    [0.75, 0.68, 0.85, 0.78],
    [0.70, 0.60, 0.80, 0.75],
    [0.65, 0.50, 0.75, 0.70],
]
errors = [
    [0.04, 0.03, 0.02, 0.02],
    [0.05, 0.04, 0.03, 0.03],
    [0.06, 0.05, 0.04, 0.03],
    [0.05, 0.04, 0.02, 0.03],
]
percentages = [
    "+8%",
    "+6%",
    "+10%",
    "+8%",
    "+7%",
    "+5%",
    "+8%",
    "+6%",
    "+12%",
    "+10%",
    "+8%",
    "+7%",
    "+15%",
    "+12%",
    "+9%",
    "+6%",
][::-1]
xlim = [0.4, 1.0]

# Text Configurations
xlabel = "Performance Metrics"
ylabel = "Case Types"
title = "Performance of Different Case Types for Legal Outcomes"
supertitle = "Legal Domain: Case Performance Analysis"
legendlabels = ["Case Duration", "Resolution Rate", "Client Satisfaction", "Success Rate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axes = plt.subplots(4, 1, figsize=(10, 10), sharex=True)
colors = ["#8BC34A", "#FFC107", "#03A9F4", "#E91E63"]

for i, ax in enumerate(axes):
    bars = ax.barh(subcategories, values[i][::-1], xerr=errors[i], color=colors, capsize=5, edgecolor='black')
    ax.set_yticklabels(subcategories)
    ax.set_xlim(xlim)
    ax.set_ylabel(categories[i])

    for j, v in enumerate(values[i][::-1]):
        ax.text(
            v + errors[i][j] + 0.01,
            j,
            percentages[i * 4 + j],
            color="black",
            va="center",
        )

# Super title and labels
fig.suptitle(supertitle, fontsize=14)
axes[-1].set_xlabel(xlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("errorbar_69.pdf", bbox_inches="tight")
