# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = [
    "New York",
    "London",
    "Tokyo",
    "Sydney",
    "Moscow",
    "Berlin",
    "Paris",
    "Beijing",
    "Mumbai",
    "Rio de Janeiro",
]
values = [1.2, 1.8, 2.5, -0.5, 0.3, 1.1, 2.0, -1.0, 1.4, 0.8]
errors = [0.3, 0.2, 0.4, 0.5, 0.2, 0.3, 0.4, 0.5, 0.3, 0.4]

# Axes Limits and Labels
ylabel_value = "Temperature Difference (°C)"
ylim_values = [-2, 3]

title = "Average Monthly Temperature Differences by City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#4E79A7",
    "#F28E2B",
    "#E15759",
    "#76B7B2",
    "#59A14F",
    "#EDC948",
    "#B07AA1",
    "#FF9DA7",
    "#9C755F",
    "#BAB0AC",
]

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Bar chart
bars = ax.bar(
    categories, values, yerr=errors, color=colors, capsize=5, edgecolor="black"
)
ax.set_xticks([])
ax.set_ylabel(ylabel_value)

# Set x-axis limits and y-axis limits
ax.set_ylim(ylim_values)

# Remove top and right spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(True)
ax.spines["bottom"].set_visible(True)

# Remove grid lines
ax.yaxis.grid(False)
ax.xaxis.grid(False)

# Add title
ax.set_title(title, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping of ylabel
plt.tight_layout()
plt.savefig("errorbar_71.pdf", bbox_inches="tight")
