

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New dataset related to sports performance over different decades
groups = [
    "Football: 1980s",
    "Basketball: 1990s",
    "Tennis: 2000s",
    "Athletics: 2010s",
    "Swimming: 2020s",
    "Cycling: 1980s",
    "Gymnastics: 1990s",
]

solid_bar_values = np.random.rand(7) * 0.7
striped_bar_values = np.random.rand(7) * 0.5
error = np.random.rand(7) * 0.1 + 0.02
labels = ["International Wins", "National Wins"]
xlabel = "Number of Wins"
ylabel = "Sports and Decades"
title = "Sports Performance Over Decades"
xlim = [0, 1.2]
ylim = [-0.5, 6.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match updated data's visualization needs
plt.figure(figsize=(10, 6))

# Create grouped bar chart with error bars
bar_width = 0.8
index = np.arange(len(groups))
plt.barh(
    index,
    solid_bar_values,
    bar_width,
    color="#8c564b",  # A sepia tone
    xerr=error,
    label=labels[0],
    capsize=5,
    edgecolor="black",
)
plt.barh(
    index,
    striped_bar_values,
    bar_width,
    left=solid_bar_values,
    color="#e377c2",  # Another historically inspired tone
    xerr=error,
    label=labels[1],
    capsize=5,
    edgecolor="black",
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_xlim(xlim)
plt.gca().set_ylim(ylim)

# Adding legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_76.pdf", bbox_inches="tight")
