
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data (replace with actual values)
groups = [
    "Movies / Cinema",
    "Movies / Streaming",
    "Music / Live",
    "Music / Online",
    "Games / Console",
    "Games / PC",
    "Books / Physical",
    "Books / Digital",
]
solid_bar_values = np.random.rand(8) * 0.5 + 0.1  # Ensure values are between 0.1 and 0.6
striped_bar_values = np.random.rand(8) * 0.4 + 0.1  # Ensure values are between 0.1 and 0.5
error = np.random.rand(8) * 0.1 + 0.01
labels = ["High Popularity", "Moderate Popularity"]
xlabel = "Popularity Index"
ylabel = "Entertainment Categories"
title = "Entertainment Popularity Analysis"
xlim = [0, 1.1]
ylim = [-0.4, 7.4]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Colors
solid_color = "#66c2a5"
striped_color = "#8da0cb"

# Create grouped bar chart with error bars
bar_width = 0.8
index = np.arange(len(groups))

# Solid bars
plt.barh(
    index,
    solid_bar_values,
    bar_width,
    color=solid_color,
    xerr=error,
    label=labels[0],
    capsize=5,
    edgecolor="black",
)

# Striped bars (moderate popularity)
plt.barh(
    index,
    striped_bar_values,
    bar_width,
    left=solid_bar_values,
    color=striped_color,
    xerr=error,
    label=labels[1],
    capsize=5,
    edgecolor="black",
)

# Add labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.yticks(index, groups, rotation=0)
plt.gca().set_xlim(xlim)
plt.gca().set_ylim(ylim)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("errorbar_77.pdf", bbox_inches="tight")
