

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for Average Monthly Rainfall
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]
rainfall = [120.5, 15.8, 78.6, 99.3, 8.8]
rainfall_errors = [5.5, 2.2, 4.0, 3.3, 1.9]

# Data for Average Monthly Temperature
temperature = [13.2, 17.4, 10.6, 20.3, 25.8]
temperature_errors = [1.0, 0.6, 1.5, 0.7, 1.3]

# Titles for the charts
chart_titles = ["Average Monthly Rainfall", "Average Monthly Temperature"]

# Labels for the axes
xlabel1 = "Rainfall (mm)"
xlabel2 = "Temperature (°C)"
ylabel = "Cities"

# Variable for file save name
filename = "errorbar_80_2.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b2", "#ccb974"]

fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(8, 8))
ax1.barh(cities, rainfall, xerr=rainfall_errors, color=colors, capsize=5, edgecolor='gray')
ax2.barh(cities, temperature, xerr=temperature_errors, color=colors, capsize=5, edgecolor='gray')

ax1.set_title(chart_titles[0])
ax2.set_title(chart_titles[1])

ax1.set_xlabel(xlabel1)
ax1.set_ylabel(ylabel)

ax2.set_xlabel(xlabel2)
ax2.set_ylabel(ylabel)

# Additional styles
ax1.grid(True, linestyle='--', alpha=0.6)
ax2.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_80.pdf", bbox_inches="tight")

