
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Countries for economic data
countries = ["USA", "China", "Germany", "India", "Brazil"]

# GDP Growth Rate (annual %)
gdp_growth = [2.3, 6.1, 1.5, 7.0, 2.2]  # Approximate values
gdp_growth_errors = [0.3, 0.5, 0.2, 0.7, 0.4]  # Error estimates

# Unemployment Rate (% of labor force)
unemployment_rate = [3.6, 4.1, 3.9, 6.5, 12.0]  # Approximate percentages
unemployment_rate_errors = [0.5, 0.7, 0.5, 0.8, 1.2]  # Error estimates

# Inflation Rate (annual %)
inflation_rate = [2.1, 2.9, 1.4, 5.5, 3.8]  # Approximate percentages
inflation_rate_errors = [0.3, 0.4, 0.2, 0.6, 0.7]  # Error estimates

titles = [
    "GDP Growth Rate (Annual %)",
    "Unemployment Rate (% of Labor Force)",
    "Inflation Rate (Annual %)",
]
xlabels = ["GDP Growth Rate (%)", "% of Labor Force", "Inflation Rate (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot for each category
fig, (ax1, ax2, ax3) = plt.subplots(3, 1, figsize=(6, 9))
# Custom colors for economic charts
colors = ["#6baed6", "#9ecae1", "#c6dbef", "#fde0dd", "#fa9fb5"]

def add_bars_with_annotations(ax, data, errors, colors):
    bars = ax.barh(countries, data, xerr=errors, color=colors, capsize=5, edgecolor="black")
    for i, bar in enumerate(bars):
        width = bar.get_width()
        label_x_pos = bar.get_width() + errors[i] * 0.2
        ax.text(
            label_x_pos, bar.get_y() + bar.get_height(), f"{width:.1f}", va="center"
        )

# Plot GDP Growth Rate on the first subplot
ax1.barh(
    countries,
    gdp_growth,
    xerr=gdp_growth_errors,
    edgecolor="black",
    color=colors,
    capsize=5,
)
add_bars_with_annotations(ax1, gdp_growth, gdp_growth_errors, colors)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.xaxis.grid(True, linestyle="--")
ax1.spines["right"].set_visible(False)
ax1.spines["top"].set_visible(False)

# Plot Unemployment Rate on the second subplot
ax2.barh(
    countries,
    unemployment_rate,
    xerr=unemployment_rate_errors,
    edgecolor="black",
    color=colors,
    capsize=5,
)
add_bars_with_annotations(ax2, unemployment_rate, unemployment_rate_errors, colors)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.xaxis.grid(True, linestyle="--")
ax2.spines["right"].set_visible(False)
ax2.spines["top"].set_visible(False)

# Plot Inflation Rate on the third subplot
ax3.barh(
    countries,
    inflation_rate,
    xerr=inflation_rate_errors,
    edgecolor="black",
    color=colors,
    capsize=5,
)
add_bars_with_annotations(ax3, inflation_rate, inflation_rate_errors, colors)
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.xaxis.grid(True, linestyle="--")
ax3.spines["right"].set_visible(False)
ax3.spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_82.pdf", bbox_inches="tight")
