
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Regions for art influence
regions = ["Europe", "Asia", "North America", "South America", "Africa"]

# Influence of Different Art Movements (% of respondents feeling influenced, hypothetical data)
art_movement_influence = [50, 35, 40, 30, 25]
art_movement_influence_errors = [4, 5, 4, 3, 2]

# Number of Art Exhibitions (in tens, hypothetical data)
art_exhibitions = [150, 100, 120, 80, 60]
art_exhibitions_errors = [12, 10, 15, 9, 6]

# Public Interest in Art Courses (number of art courses offered, hypothetical data)
public_art_courses = [40, 30, 35, 25, 20]
public_art_courses_errors = [3, 4, 3, 2, 2]

titles = [
    "Influence of Art Movements",
    "Number of Art Exhibitions",
    "Public Interest in Art Courses",
]
xlabels = ["% of Respondents", "Number of Exhibitions (in tens)", "Number of Courses"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot for each category
fig, (ax1, ax2, ax3) = plt.subplots(3, 1, figsize=(6, 9))
# Elegant color scheme for art-themed charts
colors = ['#8E7CC3', '#D4A6C8', '#F7CAC9', '#92A8D1', '#034F84']

def add_bars_with_annotations(ax, data, errors, colors):
    bars = ax.barh(regions, data, xerr=errors, color=colors, capsize=0)
    for i, bar in enumerate(bars):
        width = bar.get_width()
        label_x_pos = bar.get_width() + errors[i] * 0.2
        ax.text(
            label_x_pos, bar.get_y() + bar.get_height() / 2, f"{width}", va="bottom"
        )

# Plot Influence of Different Art Movements on the first subplot
ax1.barh(
    regions,
    art_movement_influence,
    xerr=art_movement_influence_errors,
    edgecolor="black",
    color=colors,
    capsize=0,
)
add_bars_with_annotations(ax1, art_movement_influence, art_movement_influence_errors, colors)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.xaxis.grid(True, linestyle="--")
ax1.spines["right"].set_visible(False)
ax1.spines["top"].set_visible(False)

# Plot Number of Art Exhibitions on the second subplot
ax2.barh(
    regions,
    art_exhibitions,
    xerr=art_exhibitions_errors,
    edgecolor="black",
    color=colors,
    capsize=0,
)
add_bars_with_annotations(ax2, art_exhibitions, art_exhibitions_errors, colors)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.xaxis.grid(True, linestyle="--")
ax2.spines["right"].set_visible(False)
ax2.spines["top"].set_visible(False)

# Plot Public Interest in Art Courses on the third subplot
ax3.barh(
    regions,
    public_art_courses,
    xerr=public_art_courses_errors,
    edgecolor="black",
    color=colors,
    capsize=0,
)
add_bars_with_annotations(ax3, public_art_courses, public_art_courses_errors, colors)
ax3.set_title(titles[2])
ax3.set_xlabel(xlabels[2])
ax3.xaxis.grid(True, linestyle="--")
ax3.spines["right"].set_visible(False)
ax3.spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("errorbar_83.pdf", bbox_inches="tight")
