

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data representing media statistics for three different sectors
categories = ["Print Media", "Digital Media", "Broadcast Media"]
metrics = [
    "Audience Reach",
    "Content Quality",
    "Advertising Revenue",
    "Public Engagement",
]
performance = np.array(
    [
        [75, 85, 55, 60],
        [50, 90, 70, 75],
        [65, 80, 85, 90],
    ]
)
errors = np.array(
    [
        [6, 5, 7, 6],
        [7, 6, 6, 7],
        [6, 7, 5, 6],
    ]
)
ylim = [30, 100]
ylabel = "Percentage"

# Labels for the x-axis and the legend
xlabel = ["Metrics"]
legendlabels = metrics

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure size to match a 3x1 subplot layout
fig, axes = plt.subplots(3, 1, figsize=(10, 9), sharex=True)
# Colors, choosing a professional palette to differentiate the plots
colors = ["#2E86C1", "#28B463", "#C0392B", "#F39C12"]

# Plotting bars
for i, ax in enumerate(axes):
    for j, metric in enumerate(metrics):
        ax.bar(
            j,
            performance[i, j],
            width=0.8,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=metric if i == 0 else "",
        )

    # Setting x-axis labels, y-axis limits, and titles
    ax.set_xticks(range(len(metrics)))
    ax.set_xticklabels(metrics, rotation=45)
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {categories[i]}")
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

# Adding a legend outside of the plot on top
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=len(metrics))

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to prevent overlap and ensure labels are visible
plt.tight_layout()
plt.savefig("errorbar_85.pdf", bbox_inches="tight")
