# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)  # For reproducibility

# Data representing sales statistics for three different product categories
categories = ["Electronics", "Clothing", "Groceries"]
quarters = ["Q1", "Q2", "Q3", "Q4"]
performance = np.array(
    [
        [150, 200, 250, 300],
        [100, 150, 200, 250],
        [80, 120, 160, 200],
    ]
)
errors = np.array(
    [
        [10, 15, 20, 25],
        [8, 12, 16, 20],
        [5, 10, 15, 20],
    ]
)
ylim = [0, 350]
ylabel = "Sales (Units)"
legendlabels = ["Q1 Sales", "Q2 Sales", "Q3 Sales", "Q4 Sales"]
suptitle = "Quarterly Sales Statistics for Product Categories"
filename = "errorbar_87_1.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axes = plt.subplots(3, 1, figsize=(10, 9), sharex=True)
colors = [
    "#3498db",
    "#2ecc71",
    "#e67e22",
    "#9b59b6",
]  # New color scheme reflecting the sales domain

# Plotting bars
for i, ax in enumerate(axes):
    for j, quarter in enumerate(quarters):
        ax.bar(
            j,
            performance[i, j],
            width=0.8,
            color=colors[j],
            yerr=errors[i, j],
            capsize=5,
            label=quarter if i == 0 else "",
        )

    # Setting x-axis labels, y-axis limits, and titles for each subplot
    ax.set_xticks(range(len(quarters)))
    ax.set_xticklabels(quarters, rotation=45)
    ax.set_ylim(ylim)
    ax.set_xlabel(f"({chr(97+i)}) {categories[i]}")
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True)
    ax.set_axisbelow(True)

# Adding a legend outside of the plot on top
fig.legend(
    legendlabels, loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=len(quarters)
)

# Adding a suptitle to the figure
fig.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])  # Adjust layout to make space for the suptitle
plt.savefig("errorbar_87.pdf", bbox_inches="tight")
