

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sports data for different sports
sports = ["Basketball", "Soccer", "Tennis", "Swimming"]
x = np.arange(len(sports))  # Location of labels on the x-axis

# Simplifying data arrays to two periods per metric
training_hours = np.array(
    [np.random.uniform(15, 25, 4), np.random.uniform(10, 20, 4)]
).T  # Pre-season and In-season training hours
audience_size = np.array(
    [np.random.uniform(20000, 50000, 4), np.random.uniform(10000, 30000, 4)]
).T  # Pre-season and In-season audience size
competition_year = np.array(
    [np.random.uniform(2000, 2010, 4), np.random.uniform(2011, 2020, 4)]
).T  # Pre-season and In-season competition years
trophies_won = np.array(
    [np.random.uniform(5, 10, 4), np.random.uniform(1, 5, 4)]
).T  # Pre-season and In-season trophies won
# Errors for each period
training_hours_errors = np.array([np.random.randint(1, 3, 4), np.random.randint(1, 3, 4)]).T
audience_size_errors = np.array([np.random.randint(1000, 2000, 4), np.random.randint(500, 1000, 4)]).T
year_errors = np.array([np.random.randint(1, 3, 4), np.random.randint(1, 2, 4)]).T
trophies_errors = np.array([np.random.randint(1, 2, 4), np.random.randint(1, 2, 4)]).T
labels = ["Pre-season", "In-season"]
titles = [
    "Average Training Hours",
    "Average Audience Size",
    "Average Competition Year",
    "Average Trophies Won",
]
ylabels = ["Hours", "Audience", "Year", "Trophies"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(2, 2, figsize=(10, 5))  # Adjusted to 2 rows and 2 columns
axs = axs.flatten()
# Define colors for each set of bars to keep the design cohesive and attractive
colors = [
    ["#ffcccb", "#ff6666"],  # Pre-season and In-season for training hours
    ["#c2eafc", "#005b96"],  # Pre-season and In-season for audience size
    ["#ffa07a", "#ff4500"],  # Pre-season and In-season for competition years
    ["#98fb98", "#32cd32"],
]  # Pre-season and In-season for trophies won


# Helper function to plot data
def plot_data(ax, j, data, errors, title, ylabel):
    for i in range(2):  # Adjusted to only two bars per genre
        ax.bar(
            x + i * 0.2,
            data[:, i],
            yerr=errors[:, i],
            color=colors[j][i],
            label=labels[i],
            width=0.2,
            capsize=3,
        )
    ax.set_title(title)
    ax.set_xticks(x + 0.1)  # Adjust position to center the group
    ax.set_xticklabels(sports)
    ax.set_ylabel(ylabel)
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.4), ncol=2)


# Plot each category of sports data
plot_data(
    axs[0],
    0,
    training_hours,
    training_hours_errors,
    titles[0],
    ylabels[0],
)
plot_data(axs[1], 1, audience_size, audience_size_errors, titles[1], ylabels[1])
plot_data(axs[2], 2, competition_year, year_errors, titles[2], ylabels[2])
plot_data(axs[3], 3, trophies_won, trophies_errors, titles[3], ylabels[3])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_89.pdf", bbox_inches="tight")

