
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Moved "import numpy as np" to Part 2
np.random.seed(0)

# Agricultural data for different regions
regions = ["Midwest USA", "Central Europe", "Southeast Asia", "South America"]
x = np.arange(len(regions))  # Location of labels on the x-axis

# Generating new plausible agricultural data
crop_yield = np.array(
    [np.random.uniform(3, 8, 4), np.random.uniform(4, 10, 4)]
).T  # Spring and Autumn crop yield
rainfall = np.array(
    [np.random.uniform(200, 800, 4), np.random.uniform(300, 1200, 4)]
).T  # Spring and Autumn rainfall
temperature = np.array(
    [np.random.uniform(10, 25, 4), np.random.uniform(15, 30, 4)]
).T  # Spring and Autumn temperature
soil_ph = np.array(
    [np.random.uniform(5.5, 7, 4), np.random.uniform(5, 7.5, 4)]
).T  # Spring and Autumn soil pH

# Errors for each season
crop_yield_errors = np.array([np.random.uniform(0.1, 0.3, 4), np.random.uniform(0.1, 0.3, 4)]).T
rainfall_errors = np.array([np.random.uniform(20, 50, 4), np.random.uniform(20, 50, 4)]).T
temperature_errors = np.array([np.random.uniform(1, 2, 4), np.random.uniform(1, 2, 4)]).T
soil_ph_errors = np.array([np.random.uniform(0.1, 0.5, 4), np.random.uniform(0.1, 0.5, 4)]).T

labels = ["Spring", "Autumn"]
titles = [
    "Average Crop Yield",
    "Total Rainfall",
    "Average Temperature",
    "Soil pH Levels",
]
ylabels = ["Yield (tons/hectare)", "Rainfall (mm)", "Temperature (°C)", "pH"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, axs = plt.subplots(2, 2, figsize=(10, 5))  # Adjusted to 2 rows and 2 columns
axs = axs.flatten()

# Define colors for each set of bars to keep the design cohesive and attractive
colors = [
    ["#A3E4D7", "#76D7C4"],  # Spring and Autumn for crop yield
    ["#F9E79F", "#F7DC6F"],  # Spring and Autumn for rainfall
    ["#AED6F1", "#5499C7"],  # Spring and Autumn for temperature
    ["#F5B7B1", "#CD6155"],
]  # Spring and Autumn for soil pH

# Helper function to plot data
def plot_data(ax, j, data, errors, title, ylabel):
    for i in range(2):  # Adjusted to only two bars per region
        ax.bar(
            x + i * 0.2,
            data[:, i],
            yerr=errors[:, i],
            color=colors[j][i],
            label=labels[i],
            width=0.2,
            capsize=3,
        )
    ax.set_title(title)
    ax.set_xticks(x + 0.1)  # Adjust position to center the group
    ax.set_xticklabels(regions)
    ax.set_ylabel(ylabel)
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.4), ncol=2)

# Plot each category of agricultural data
plot_data(axs[0], 0, crop_yield, crop_yield_errors, titles[0], ylabels[0])
plot_data(axs[1], 1, rainfall, rainfall_errors, titles[1], ylabels[1])
plot_data(axs[2], 2, temperature, temperature_errors, titles[2], ylabels[2])
plot_data(axs[3], 3, soil_ph, soil_ph_errors, titles[3], ylabels[3])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_90.pdf", bbox_inches="tight")

