# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Financial data for different countries
categories = ["Canada", "UK", "France", "Japan", "Australia"][::-1]
stock_price_change = [-1.2, -3.5, -2.7, -1.8, -0.9][::-1]  # Stock Price Change (%)
stock_error = [0.4, 0.6, 0.3, 0.5, 0.2][::-1]  # Error values for Stock Price Change

dividend_yield = [4.1, 5.2, 3.8, 2.9, 3.4][::-1]  # Dividend Yield (%)
dividend_error = [0.5, 0.6, 0.7, 0.4, 0.3][::-1]  # Error values for Dividend Yield
xlabels = ["Stock Price Change (%)", "Dividend Yield (%)"]
titles = ["Stock Price Change by Country", "Dividend Yield by Country"]
xlims = [[-5, 0], [0, 6]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart with subplots
fig, axes = plt.subplots(1, 2, figsize=(12, 6), sharey=True)  # Adjust figure size

# Setting colors for the bars
neg_colors = ["#ff9999"] * 5
pos_colors = ["#66b3ff"] * 5

# Plotting bars for negative values (Stock Price Change)
bars = axes[0].barh(
    categories,
    stock_price_change,
    color=neg_colors,
    edgecolor="black",
    height=0.5,
    xerr=stock_error,
    capsize=5,
)
axes[0].set_xlabel(xlabels[0])
axes[0].set_title(titles[0])
axes[0].invert_yaxis()
axes[0].set_xlim(xlims[0])
axes[0].xaxis.grid(True, linestyle="--", linewidth=0.7)
axes[0].spines["top"].set_visible(False)
axes[0].spines["right"].set_visible(False)

# Plotting bars for positive values (Dividend Yield)
bars2 = axes[1].barh(
    categories,
    dividend_yield,
    color=pos_colors,
    edgecolor="black",
    height=0.5,
    xerr=dividend_error,
    capsize=5,
)
axes[1].set_xlabel(xlabels[1])
axes[1].set_title(titles[1])
axes[1].invert_yaxis()
axes[1].set_xlim(xlims[1])
axes[1].xaxis.grid(True, linestyle="--", linewidth=0.7)
axes[1].spines["top"].set_visible(False)
axes[1].spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_92.pdf", bbox_inches="tight")
