
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Departments and values for different departments
departments = ["Health", "Education", "Defense", "Transport", "Environment"][::-1]
budget_allocation = [-9000, -15000, -12000, -8000, -6000][::-1]  # Budget in billion dollars
budget_error = [900, 1200, 1100, 850, 750][::-1]  # Error values for budget

approval_rating = [60, 70, 55, 65, 50][::-1]  # Approval rating in percentage
approval_error = [5, 7, 4.5, 5.5, 4.0][::-1]  # Error values for approval rating
xlabels = ["Budget Allocation (Billion $)", "Approval Rating (%)"]
titles = ["Budget Allocation by Department", "Approval Rating by Department"]
xlims = [[-16000, 0], [0, 80]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart with subplots
fig, axes = plt.subplots(1, 2, figsize=(12, 8), sharey=True)  # Adjust figure size

# Setting colors for the bars
neg_colors = ["#FF9999"] * 5  # Warm red color for negative values
pos_colors = ["#98FB98"] * 5  # Cool green color for positive values

# Plotting bars for negative values (Budget Allocation)
bars = axes[0].barh(
    departments,
    budget_allocation,
    color=neg_colors,
    edgecolor="white",
    height=0.5,
    xerr=budget_error,
    capsize=3,
)
axes[0].set_xlabel(xlabels[0])
axes[0].set_title(titles[0], fontsize=14)
axes[0].invert_yaxis()
axes[0].set_xlim(xlims[0])
axes[0].xaxis.grid(True, linestyle='--', linewidth=0.7)
axes[0].spines["top"].set_visible(False)
axes[0].spines["right"].set_visible(False)

# Plotting bars for positive values (Approval Rating)
bars2 = axes[1].barh(
    departments,
    approval_rating,
    color=pos_colors,
    edgecolor="white",
    height=0.5,
    xerr=approval_error,
    capsize=3,
)
axes[1].set_xlabel(xlabels[1])
axes[1].set_title(titles[1], fontsize=14)
axes[1].invert_yaxis()
axes[1].set_xlim(xlims[1])
axes[1].xaxis.grid(True, linestyle='--', linewidth=0.7)
axes[1].spines["top"].set_visible(False)
axes[1].spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorbar_93.pdf", bbox_inches="tight")
