

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Data for political party support in different periods
parties = ["Party A", "Party B", "Party C"]
support_1month = [0.40, 0.30, 0.50]  # Support after 1 month
support_3months = [0.45, 0.35, 0.55]  # Support after 3 months
support_6months = [0.50, 0.40, 0.60]  # Support after 6 months
error = [0.05, 0.04, 0.03]  # Error margins for the support values

# Bar positions
x = np.arange(len(parties))
width = 0.25  # width of the bars

labels = ["1 Month", "3 Months", "6 Months"]
ylabel = "Polling Support (%)"
title = "Polling Support for Political Parties Over Time"
xlabel = "Political Parties"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
bars1 = ax.bar(
    x - width,
    support_1month,
    width,
    label=labels[0],
    color="#77B5FE",  # Sky Blue
    yerr=error,
    capsize=5,
    hatch="//",
)
bars2 = ax.bar(
    x,
    support_3months,
    width,
    label=labels[1],
    color="#98FB98",  # Pale Green
    yerr=error,
    capsize=5,
    hatch="\\",
)
bars3 = ax.bar(
    x + width,
    support_6months,
    width,
    label=labels[2],
    color="#9370DB",  # Medium Purple
    yerr=error,
    capsize=5,
    hatch="--",
)

# Adding text for labels, title, and custom x-axis tick labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(parties)
ax.axhline(0, color="gray")
ax.legend()  # Adjust legend location as needed

# Adding data labels on the bars
def add_labels(bars):
    for bar in bars:
        height = bar.get_height()
        ax.annotate(
            f"{height:.2f}",
            xy=(
                bar.get_x() + bar.get_width() / 2,
                (
                    height + error[bars.index(bar)]
                    if height > 0
                    else height - error[bars.index(bar)]
                ),
            ),
            xytext=(
                0,
                3 if height > 0 else -12,
            ),  # move text up or down based on bar direction
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

add_labels(bars1)
add_labels(bars2)
add_labels(bars3)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("errorbar_94.pdf", bbox_inches="tight")
