
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = ["Wheat", "Corn", "Rice", "Soybeans", "Cotton"]
means = [3.2, 10.5, 4.6, 3.8, 2.5]  # Example average yields in tonnes per hectare
errors = [0.4, 0.6, 0.5, 0.3, 0.2]  # Example standard deviation/error in yields
dataset_mean = [4.92]  # Example overall mean yield
xlabel = "Yield (Tonnes per Hectare)"
ylabel = "Crop Types"
title = "Agricultural Yield Metrics"
label = "Overall Mean Yield"
color_scheme = "#1f77b4"  # Custom blue color for agriculture theme
error_color = "#ff7f0e"  # Custom orange color for error bars

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 8))  # Adjust figure size to match the desired dimensions
plt.errorbar(
    means,
    categories,
    xerr=errors,
    fmt="o",
    color=color_scheme,
    ecolor=error_color,
    capsize=5,
    elinewidth=2,
    markeredgewidth=2,
    label="Mean",
)
plt.axvline(dataset_mean, linestyle="--", color="green", label=label)

# Customizing the plot
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_24.pdf", bbox_inches="tight")
