# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = ["Mathematics", "Science", "English", "History", "Arts"]
means = [85.0, 78.0, 88.0, 75.0, 90.0]
errors = [5.0, 6.0, 4.0, 7.0, 3.0]
dataset_mean = [83.2]
xlabel = "Average Test Scores"
label = "Overall Mean"
ylabel = "Subjects"
title = "Average Test Scores for Various Subjects"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(10, 6))  # Adjusting figure size for better readability
plt.errorbar(
    means,
    categories,
    xerr=errors,
    fmt="o",
    color="#1f77b4",  # Blue color for points
    ecolor="#ff7f0e",  # Orange color for error bars
    capsize=5,
    label="Test Score Mean",
)
plt.axvline(
    dataset_mean, linestyle="--", color="#2ca02c", label=label
)  # Green dashed line for mean

# Customizing the plot
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjusting the layout and saving the figure
plt.tight_layout()
plt.savefig("errorpoint_26.pdf", bbox_inches="tight")
