
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New Data for plotting
philosophers = [
    "Aristotle",
    "Plato",
    "Socrates",
    "Kant",
    "Nietzsche",
    "Descartes",
    "Hume",
    "Heidegger",
    "Sartre",
    "Wittgenstein"
]
scores = [
    8.1,
    8.4,
    8.5,
    8.2,
    8.3,
    8.4,
    8.5,
    8.6,
    8.0,
    8.7,
]
errors = [
    [0.1, -0.1],
    [0.2, -0.2],
    [0.3, -0.3],
    [0.15, -0.15],
    [0.25, -0.25],
    [0.18, -0.18],
    [0.2, -0.2],
    [0.22, -0.22],
    [0.1, -0.1],
    [0.3, -0.3],
]
theories = [
    "Theory 1",
    "Theory 2",
    "Theory 3",
    "Theory 4",
    "Theory 5",
    "Theory 6",
    "Theory 7",
    "Theory 8",
    "Theory 9",
    "Theory 10",
]
xticks = np.arange(7.5, 9.0, 0.2)
xlim = [7.5, 9.0]
xvline = 8.25
xvspan = [8.2, 8.5]

# Labels
xlabel = r"Philosophical Score"
title = "Comparison of Different Philosophers' Scores"
supertitle = "Philosophical Study Results"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 8))

# Error bars with different positive and negative values
for i, (philosopher, score, error) in enumerate(zip(philosophers, scores, errors)):
    ax.errorbar(
        score,
        i,
        xerr=[[abs(error[1])], [error[0]]],
        fmt="o",
        color="#2E8B57",
        ecolor="#8B0000",
        capsize=3,
    )
    ax.text(
        score,
        i - 0.15,
        r"$%.1f^{+%.1f} _{-%.1f}$" % (score, error[0], abs(error[1])),
        va="center",
        ha="center",
        fontsize=9,
        color="#4B0082"
    )

# Highlighted region with adjusted color and alpha
ax.axvspan(xvspan[0], xvspan[1], color="#FFD700", alpha=0.3)

# Text for theories with adjusted font size
for i, theory in enumerate(theories):
    ax.text(9.05, i, theory, va="center", ha="left", fontsize=11, color="#4682B4")

# Set labels and title
ax.set_yticks(range(len(philosophers)))
ax.set_yticklabels(philosophers, fontsize=12, color="#191970")
ax.set_xlabel(xlabel, fontsize=12, color="#191970")
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlim(xlim)
ax.invert_yaxis()  
ax.axvline(x=xvline, linestyle="--", color="#FF6347")
# Adjust x-axis ticks and labels
ax.set_xticks(xticks)
ax.set_xticklabels([f"{x:.1f}" for x in xticks], fontsize=10, color="#191970")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save/show the plot
plt.suptitle(supertitle, fontsize=16, fontweight='bold')
plt.tight_layout()
plt.savefig("errorpoint_29.pdf", bbox_inches="tight")
