

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
categories = [
    "Movies",
    "TV Shows",
    "Video Games",
    "Music",
    "Theater",
    "Podcasts",
]
unique_viewer_mean = [120, 150, 130, 115, 100, 90]
unique_listener_mean = [80, 90, 85, 140, 75, 110]
unique_viewer_error = [10, 15, 12, 10, 8, 9]
unique_listener_error = [7, 8, 10, 12, 6, 8]
labels = ["Unique viewer count mean", "Unique listener count mean"]
ylabel = "Number of Unique Viewers/Listeners"
xlabel = "Entertainment Categories"
legendlabel = "Average unique listener count"
title = "Viewer and Listener Mean Count by Entertainment Category"
supertitle = "Analysis of Viewer and Listener Trends in Entertainment Domains"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
ax.errorbar(
    categories,
    unique_viewer_mean,
    yerr=unique_viewer_error,
    fmt="s",
    color="green",
    label=labels[0],
)
ax.errorbar(
    categories,
    unique_listener_mean,
    yerr=unique_listener_error,
    fmt="^",
    color="purple",
    label=labels[1],
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.axhline(
    y=np.mean(unique_listener_mean),
    color="orange",
    linestyle="--",
    label=legendlabel,
)
ax.legend()

# Super Title
fig.suptitle(supertitle, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("errorpoint_30.pdf", bbox_inches="tight")

