
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for Psychology domain
categories = [
    "Cognitive",
    "Behavioral",
    "Developmental",
    "Social",
    "Clinical",
    "Biological",
]
control_group_mean = [28, 20, 25, 35, 30, 24]  # Example mean values for control group
experimental_group_mean = [18, 14, 16, 28, 20, 18]  # Example mean values for experimental group
control_group_error = [3, 2.5, 3.5, 4, 3.2, 3]  # Example error values for control group
experimental_group_error = [2, 1.5, 2, 2.5, 2.2, 2]  # Example error values for experimental group

# Labels and text
labels = ["Control Group Mean", "Experimental Group Mean"]
ylabel = "Number of Participants"
axlabel = "Average Experimental Group Count"
xlabel = "Categories"
title = "Participants in Different Psychological Categories"
supertitle = "Analysis of Control and Experimental Group Distribution in Psychology"
legendlabels = ["Mean Control Group Count", "Mean Experimental Group Count", axlabel]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(10, 6))
ax.errorbar(
    categories,
    control_group_mean,
    yerr=control_group_error,
    fmt="s",
    color="#66c2a5",  # Green shade for control group
    label=labels[0],
    capsize=5,
    linestyle='-', 
    linewidth=2
)
ax.errorbar(
    categories,
    experimental_group_mean,
    yerr=experimental_group_error,
    fmt="^",
    color="#fc8d62",  # Orange shade for experimental group
    label=labels[1],
    capsize=5,
    linestyle='--', 
    linewidth=2
)

# Customization
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
fig.suptitle(supertitle, fontsize=14)
ax.set_xticklabels(categories, rotation=45, ha="right")

# Add horizontal line for average experimental group mean
ax.axhline(y=np.mean(experimental_group_mean), color="#8da0cb", linestyle="--", label=axlabel)

ax.legend(title="Legend", loc="upper left")

# Additional tweaks
ax.grid(True, linestyle=':', linewidth=0.6)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save and Show plot
plt.savefig("errorpoint_32.pdf", bbox_inches="tight")
