
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "Mathematics",
    "Science",
    "History",
    "Literature",
    "Art",
]  # Subjects

means = [85, 78, 92, 74, 88]  # Mean scores in each subject
errors = [3, 4, 5, 2, 3]  # Error margins
downerrors = [2, 3, 4, 1, 2]  # Down errors

legendtitles = ["Overall Mean", "Subject Mean"]
texttitle = "Overall Mean Score"
ylabel = "Scores (out of 100)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
fig, ax = plt.subplots(figsize=(10, 6))  # Adjusted figure size

# Custom colors
color = "#8b4513"  # SaddleBrown
error_color = "#a52a2a"  # Brown
mean_line_color = "#808080"  # Gray

# Plotting error bar
ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color=color,
    ecolor=error_color,
    capsize=5,
    markersize=8,
)

# Adding a legend with both "Mean" and "Dataset mean"
dataset_mean = 83  # Example overall mean score
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color=color, ecolor=error_color, capsize=5
)
dataset_mean_line = ax.axhline(
    y=dataset_mean, color=mean_line_color, linestyle="--", linewidth=1.5
)
ax.legend(
    [dataset_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for dataset mean and text annotation with a white background
ax.text(
    0.95,
    dataset_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels
ax.set_ylabel(ylabel)
ax.set_title("")
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_34.pdf", bbox_inches="tight")
