# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
categories = [
    "EMAIL",
    "SOCIAL MEDIA",
    "VIDEO CALLS",
    "PHONE CALLS",
    "MESSAGING APPS",
]
means = [0.35, 0.45, 0.25, 0.4, 0.3]
errors = [0.05, 0.04, 0.06, 0.03, 0.04]
downerrors = [0.03, 0.05, 0.04, 0.02, 0.03]
legendtitles = ["Overall Mean", "Category Mean"]
texttitle = "Overall Mean"
ylabel = "Usage Frequency (Fraction of Survey Responses)"
xlabel = "Communication Methods"

title = "Usage Frequency of Various Communication Methods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Color-related variables
fig, ax = plt.subplots(figsize=(10, 7))

ax.errorbar(
    categories,
    means,
    yerr=[errors, downerrors],
    fmt="o",
    color="forestgreen",
    ecolor="lightcoral",
    elinewidth=2,
    capsize=6,
    markerfacecolor="blue",
    markeredgewidth=2,
)

# Adding a legend with both "Category Mean" and "Overall Mean"
overall_mean = 0.35
mean_line = ax.errorbar(
    [], [], yerr=[], fmt="o", color="forestgreen", ecolor="lightcoral", capsize=6
)
overall_mean_line = ax.axhline(
    y=overall_mean, color="indigo", linestyle="--", linewidth=1.5
)
ax.legend(
    [overall_mean_line, mean_line],
    legendtitles,
    loc="upper right",
    fancybox=True,
    framealpha=1,
    shadow=True,
    borderpad=1,
)

# Adding a horizontal line for overall mean and text annotation with a white background
ax.text(
    0.95,
    overall_mean,
    texttitle,
    va="center",
    ha="right",
    backgroundcolor="white",
    transform=ax.get_yaxis_transform(),
)

# Setting labels
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title, fontsize=14, fontweight="bold")
plt.xticks(rotation=30, fontsize=10)
plt.yticks(fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_35.pdf", bbox_inches="tight")
