

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# example data for citation frequency
centuries = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12])
citations = np.array([5, 9, 15, 20, 25, 22, 18, 16, 14, 10, 8, 5])
citation_err = np.array([2.5, 1.8, 2.0, 1.7, 1.5, 1.4, 1.3, 1.5, 1.7, 1.6, 2.0, 1.9])

# lower & upper error limits
lolims = np.array([0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0], dtype=bool)
uplims = np.array([0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0], dtype=bool)
ls = "None"
century_labels = ["1st", "2nd", "3rd", "4th", "5th", "6th", "7th", "8th", "9th", "10th", "11th", "12th"]
title = "Citation Frequency of Philosophers Over Centuries"
xlim = [0, 13]
xlabel = "Centuries"
ylabel = "Citation Frequency"
legend_labels = [
    "Standard Error",
    "Upper Limits",
    "Lower Limits",
    "Upper and Lower Limits",
    "Random Adjustments",
]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#e63946", "#f4a261", "#e76f51", "#2a9d8f", "#264653"]
fig, ax = plt.subplots(figsize=(10, 6))

# standard error bars
ax.errorbar(centuries, citations, yerr=citation_err, label=legend_labels[0], linestyle=ls, color=colors[0], marker='o')

# including upper limits
ax.errorbar(
    centuries,
    citations + 5,
    yerr=citation_err,
    uplims=uplims,
    label=legend_labels[1],
    linestyle=ls,
    color=colors[1],
    marker='v'
)

# including lower limits
ax.errorbar(
    centuries,
    citations - 5,
    yerr=citation_err,
    lolims=lolims,
    label=legend_labels[2],
    linestyle=ls,
    color=colors[2],
    marker='^'
)

# including upper and lower limits
ax.errorbar(
    centuries,
    citations - 10,
    yerr=citation_err,
    lolims=lolims,
    uplims=uplims,
    marker="s",
    markersize=8,
    label=legend_labels[3],
    linestyle=ls,
    color=colors[3],
)

# Mock up some limits by modifying previous data
xlolims = np.zeros_like(centuries)
xuplims = np.zeros_like(centuries)
yerr2 = np.full_like(centuries, 2.0)
xlolims[[4]] = True  # only limited at this index
xuplims[[9]] = True  # only limited at this index

# do the plotting
ax.errorbar(
    centuries,
    citations + 3,
    xerr=0.2,
    yerr=yerr2,
    xlolims=xlolims,
    xuplims=xuplims,
    marker="D",
    markersize=8,
    linestyle="none",
    label=legend_labels[4],
    color=colors[4],
)

# tidy up the figure
ax.set_xlim(xlim)
ax.set_xticks(centuries)
ax.set_xticklabels(century_labels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

plt.legend(bbox_to_anchor=(0.5, 1.15), ncol=5, loc="upper center")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("errorpoint_36.pdf", bbox_inches="tight")
